<?php
/**
 * Copyright (C) 2014-2020 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}

class Ai1wmae_Import_Settings {

	public static function execute( $params ) {

		// Set progress
		Ai1wm_Status::info( __( 'Getting Backblaze B2 settings...', AI1WMAE_PLUGIN_NAME ) );

		$settings = array(
			'ai1wmae_b2_cron_timestamp'       => get_option( 'ai1wmae_b2_cron_timestamp', time() ),
			'ai1wmae_b2_cron'                 => get_option( 'ai1wmae_b2_cron', array() ),
			'ai1wmae_b2_account_id'           => get_option( 'ai1wmae_b2_account_id', false ),
			'ai1wmae_b2_application_key'      => get_option( 'ai1wmae_b2_application_key', false ),
			'ai1wmae_b2_bucket_id'            => get_option( 'ai1wmae_b2_bucket_id', false ),
			'ai1wmae_b2_bucket_name'          => get_option( 'ai1wmae_b2_bucket_name', ai1wm_archive_bucket() ),
			'ai1wmae_b2_backups'              => get_option( 'ai1wmae_b2_backups', false ),
			'ai1wmae_b2_total'                => get_option( 'ai1wmae_b2_total', false ),
			'ai1wmae_b2_days'                 => get_option( 'ai1wmae_b2_days', false ),
			'ai1wmae_b2_file_chunk_size'      => get_option( 'ai1wmae_b2_file_chunk_size', AI1WMAE_DEFAULT_FILE_CHUNK_SIZE ),
			'ai1wmae_b2_notify_toggle'        => get_option( 'ai1wmae_b2_notify_toggle', false ),
			'ai1wmae_b2_notify_error_toggle'  => get_option( 'ai1wmae_b2_notify_error_toggle', false ),
			'ai1wmae_b2_notify_error_subject' => get_option( 'ai1wmae_b2_notify_error_subject', false ),
			'ai1wmae_b2_notify_email'         => get_option( 'ai1wmae_b2_notify_email', false ),
			'ai1wmae_b2_lock_mode'            => get_option( 'ai1wmae_b2_lock_mode', false ),
		);

		// Save settings.json file
		$handle = ai1wm_open( ai1wm_settings_path( $params ), 'w' );
		ai1wm_write( $handle, json_encode( $settings ) );
		ai1wm_close( $handle );

		// Set progress
		Ai1wm_Status::info( __( 'Done getting Backblaze B2 settings.', AI1WMAE_PLUGIN_NAME ) );

		return $params;
	}
}
